<?php
session_start();
include("include/dbconnect.php");
include("include/functions.php");
if ($_SESSION['VALID_USER_NAME'] == false) {
  header("location: lock_screen");
}
$comp_id = $_SESSION['comp_id'];
$comp_name = $_SESSION["COMP_NAME"];
$emp_id = $_SESSION["VALID_USER_ID"];
date_default_timezone_set("Asia/Karachi");
$sysdate = date("Y-m-d");
?>
<?php include('header.php'); ?>


<title>Dashboard | <?php echo $row->acct_name;?></title>

<?php include('left.php'); ?>







<!-- Main Content -->
<div class="main-content">
  <section class="section">
    <ul class="breadcrumb breadcrumb-style ">
      <li class="breadcrumb-item">
        <h4 class="page-title m-b-0">Dashboard</h4>
      </li>
      
      <li class="breadcrumb-item active">Dashboard</li>
    </ul>

    <div class="row">

      <!-----------------------START TODAY SALE-------------------->
      <?php

      try {
        $slquery = "SELECT
                                          SUM(net_amt) amount
                                      FROM
                                          sl_invoice m
                                      WHERE 1 = 1  and m.comp_id = '$comp_id' 
                                        and  m.voucher_date = '$sysdate'";
        $slresult = $dbcon->prepare($slquery);
        $slresult->execute();
      } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
      }
      $slrow = $slresult->fetch(PDO::FETCH_OBJ);
      $today = $slrow->amount;
      ?>


      <div class="col-lg-4 col-md-6 col-sm-6 col-12">
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-purple">
            <i class="fas fa-dollar-sign"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo $currency_sign .  ' ' . format_number($today, $amt_decimals); ?>
                </h3>
                <span class="text-muted">Revenue</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END TODAY SALE-------------------->




      <!-----------------------START TODAY PROFIT MARGIN-------------------->
      <?php
      $msqlquery = "SELECT

            if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_qty,v.cr_qty) qty,
            if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt) amt,
            
            if(substring(v.voucher_id,1,2) in('SL','ST'),if(ifnull(v.cost_amt,0)=0,0,v.cr_amt-v.cost_amt) ,0) profit
            FROM v_p_vouchers v
            LEFT JOIN v_item i on v.stock_code=i.stock_code
              
              
              WHERE
                1 = 1 and v.comp_id = '$comp_id' and  v.voucher_date = '$sysdate' and if(substring(v.voucher_id,1,2) in('PL','RT'),v.db_amt,v.cr_amt)<>0
                order by v.voucher_date, v.voucher_id,v.lineitem/1";
      try {
        $q_result = $dbcon->prepare($msqlquery);
        $q_result->execute();
      } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
      }



      $row = $q_result->fetch(PDO::FETCH_OBJ);
      $gp = $row->profit;
      $sale_amt = $row->amt;


      if ($sale_amt != '') {
        $pm = intval($gp * 100 / $sale_amt);
      }




      ?>
      <div class="col-lg-4 col-md-6 col-sm-6 col-12">
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-green">
            <i class="fal fa fa-balance-scale"></i>
          </div>


          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo round($pm); ?> %
                </h3>
                <span class="text-muted">Profit margin</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END TODAY PROFIT MARGIN-------------------->




      <!-----------------------START TODAY PROFIT-------------------->
      <div class="col-lg-4 col-md-6 col-sm-6 col-12">
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-cyan">
            <i class="fas fa-chart-line"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo round($gp); ?>
                </h3>
                <span class="text-muted">Profit</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END TODAY PROFIT-------------------->
    </div>

    <div class="row">

      <!-----------------------START SALE COUNT-------------------->
      <?php
      try {
        $slquery = "SELECT SUM(d.qty) qty_count
                            FROM sl_invoice m 
                            LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id and m.year_id = d.year_id and m.voucher_id = d.voucher_id
                             WHERE 1 = 1  and m.comp_id = '$comp_id' and m.voucher_date = '$sysdate'";
        $slresult = $dbcon->prepare($slquery);
        $slresult->execute(array());
      } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
      }
      $row = $slresult->fetch(PDO::FETCH_OBJ);
      $qty_count = $row->qty_count;
      ?>
      <div class="col-lg-3 col-md-6 col-sm-6 col-12">
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-orange">
            <i class="fa fa-cart-plus"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo round($qty_count); ?>
                </h3>
                <span class="text-muted">Sales Count</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END SALE COUNT-------------------->


      <!-----------------------START TODAY SALE CUSTOMER-------------------->
      <?php
      try {
        $slquery = "SELECT count(s.acct_id) cust_count
                            FROM sl_invoice s WHERE 1 = 1   and s.comp_id = '$comp_id' and  s.voucher_date = '$sysdate'  ";
        $slresult = $dbcon->prepare($slquery);
        $slresult->execute(array());
      } catch (PDOException $e) {
        echo "Error : " . $e->getMessage();
      }
      $row = $slresult->fetch(PDO::FETCH_OBJ);
      $cust_count = $row->cust_count;
      ?>
      <div class="col-lg-3 col-md-6 col-sm-6 col-12">
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-orange">
            <i class="fa fa-users"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo $cust_count; ?>
                </h3>
                <span class="text-muted">Customer</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END TODAY SALE CUSTOMER-------------------->



      <div class="col-lg-3 col-md-6 col-sm-6 col-12">

        <!-----------------------START SALES DISCOUNT -------------------->
        <?php

        try {
          $slquery = "SELECT
                            SUM(disc_amt) amount
                        FROM
                            sl_invoice m
                        WHERE 1 = 1  and m.comp_id = '$comp_id'  and 
                            m.voucher_date = '$sysdate'";
          $slresult = $dbcon->prepare($slquery);
          $slresult->execute(array());
        } catch (PDOException $e) {
          echo "Error : " . $e->getMessage();
        }
        $slrow = $slresult->fetch(PDO::FETCH_OBJ);
        $disc_amt = $slrow->amount;
        ?>
        <div class="card card-statistic-1">
          <div class="card-icon l-bg-orange">
            <i class="fa fa-percentage"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo $currency_sign .  ' ' . format_number($disc_amt, $amt_decimals); ?>
                </h3>
                <span class="text-muted">Discounts</span>
              </div>
            </div>
          </div>
        </div>
        <!-----------------------END SALES DISCOUNT -------------------->
      </div>


      <!-----------------------START SALES REFUND -------------------->
      <div class="col-lg-3 col-md-6 col-sm-6 col-12">
        <?php

        try {
          $slquery = "SELECT
                            IFNULL(SUM( net_amt ), 0) amount 
                        FROM
                            sl_return m
                       WHERE 1 =  1  and m.comp_id = '$comp_id' and m.voucher_date = '$sysdate'";
          $slresult = $dbcon->prepare($slquery);
          $slresult->execute(array());
        } catch (PDOException $e) {
          echo "Error : " . $e->getMessage();
        }
        $row = $slresult->fetch(PDO::FETCH_OBJ);
        $refund = $row->amount;



        ?>

        <div class="card card-statistic-1">
          <div class="card-icon l-bg-orange">
            <i class="fa fa-arrow-left"></i>
          </div>
          <div class="card-wrap">
            <div class="padding-20">
              <div class="text-right">
                <h3 class="font-light mb-0">
                  <i class="ti-arrow-up text-success"></i>
                  <?php echo $currency_sign .  ' ' . format_number($refund, $amt_decimals); ?>
                </h3>
                <span class="text-muted">Refunds</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-----------------------END SALES REFUND -------------------->
    </div>



    <div class="row">
      <div class="col-md-12 col-lg-12 col-xl-12 ">
        <div class="card">
          <div class="card-header">
            <h4>Revenue Chart</h4>
            <div class="card-header-action">
              <ul class="nav nav-pills" role="tablist" id="chart-tabs">
                <li class="nav-item">
                  <a class="nav-link active card-tab-style" data-toggle="tab" data-id="1" role="tab" aria-selected="true">2017</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link card-tab-style" data-toggle="tab" data-id="2" role="tab" aria-selected="false">2018</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link card-tab-style" data-toggle="tab" data-id="3" role="tab" aria-selected="false">2019</a>
                </li>
              </ul>
            </div>
          </div>
          <div class="card-body">
            <div id="chart1"></div>
          </div>
        </div>
      </div>

    </div>





    <div class="row">


      <!-------------------------------START CUSTOMER SUMMARY--------------------->
      <?php
      if (find_value("users", 'db_debtor', " and emp_id = '$emp_id'") == 'Y') {
        //                and v.acct_id not in('2610000462', '2610000463', '2610000464')
        $total = find_value("(SELECT  
                sum(round(ifnull(v.debit,0)-ifnull(v.credit,0))) total
                FROM
                v_vouchers v
                INNER JOIN v_party n ON v.acct_id = n.acct_id
                LEFT JOIN company c ON v.comp_id = c.comp_id
                WHERE 1 = 1 AND n.party_type='C'
                and v.acct_id not in('2610000462', '2610000463', '2610000464')
                ) v", "total", "");
      ?>
        <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">

          <div class="card">
            <div class="card-header">
              <h4><b>Customer Balances <?php echo format_number_drcr($total, 0); ?></b></h4>
              <div class="card-header-form">

              </div>
            </div>
            <div class="card-body">
              <div class="table-responsive proTeamScroll" id="proTeamScroll">
                <table class=" customer_table table table-bordered " id="customer_table">
                  <thead>
                    <tr>
                      <th>Account</th>
                      <th>Balances</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php

                    try {
                      $sumsqlquery = "SELECT  v.acct_id, n.acct_name,
								sum(round(ifnull(v.debit,0)-ifnull(v.credit,0))) o_bal
								FROM
								v_vouchers v
								INNER JOIN v_party n ON v.acct_id = n.acct_id
								LEFT JOIN company c ON v.comp_id = c.comp_id
								WHERE 1 = 1 AND n.party_type='C' and n.acct_name is not null
                                 and v.acct_id not in('2610000462', '2610000463', '2610000464') 
						GROUP BY v.acct_id, n.acct_name
						HAVING sum(ifnull(v.debit,0)-ifnull(v.credit,0))<>0
						ORDER BY 3 desc";

                      $sumresult = $dbcon->prepare($sumsqlquery);
                      $sumresult->execute(array());
                    } catch (PDOException $e) {
                      echo "Error : " . $e->getMessage();
                    }
                    while ($report_row = $sumresult->fetch(PDO::FETCH_ASSOC)) {
                    ?>
                      <tr>
                        <td><a href="ledger?acct_id=<?php echo ($report_row['acct_id']); ?>&ledger=N" target="_blank"><?php echo $report_row['acct_name']; ?></a></td>
                        <td align=right><?php echo round($report_row['o_bal'], 0); ?></td>
                      </tr>
                    <?php
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      <?php } ?>
      <!-------------------------------END CUSTOMER SUMMARY--------------------->




      
      <!-------------------------------START SUPPLIER SUMMARY--------------------->
      <?php
                if (find_value("users", 'db_creditor', " and emp_id = '$emp_id'")=='Y') {
                $total = find_value("(SELECT  v.acct_id, n.acct_name,
								sum(round(ifnull(v.debit,0)-ifnull(v.credit,0))) total
								FROM
								v_vouchers v
								INNER JOIN v_party n ON v.acct_id = n.acct_id
								LEFT JOIN company c ON v.comp_id = c.comp_id
								WHERE 1 = 1 AND n.party_type='S' and n.acct_name is not null
                ) v","total","");
                ?>
        <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">

          <div class="card">
            <div class="card-header">
              <h4><b>Supplier Balances  <?php echo format_number_drcr($total,0);?></b></h4>
              <div class="card-header-form">

              </div>
            </div>
            <div class="card-body">
              <div class="table-responsive proTeamScroll" id="proTeamScroll">
                <table class=" customer_table table table-bordered " id="customer_table">
                  <thead>
                    <tr>
                      <th>Account</th>
                      <th>Balances</th>
                    </tr>
                  </thead>
                  <tbody>
                  <?php

                  try {
                      $sumsqlquery = "SELECT  v.acct_id, n.acct_name,
                  sum(round(ifnull(v.debit,0)-ifnull(v.credit,0))) o_bal
                  FROM
                  v_vouchers v
                  INNER JOIN v_party n ON v.acct_id = n.acct_id
                  LEFT JOIN company c ON v.comp_id = c.comp_id
                  WHERE 1 = 1 AND n.party_type='S'
                  GROUP BY v.acct_id, n.acct_name
                  HAVING sum(ifnull(v.debit,0)-ifnull(v.credit,0))<>0
                  ORDER BY 3 desc";

                      $sumresult = $dbcon->prepare($sumsqlquery);
                      $sumresult->execute(array());
                  } catch (PDOException $e) {
                      echo "Error : " . $e->getMessage();
                  }
                  while ($report_row = $sumresult->fetch(PDO::FETCH_ASSOC)) {
                      ?>
                      <tr>
                        <td><a href="ledger?acct_id=<?php echo ($report_row['acct_id']); ?>&ledger=N" target="_blank"><?php echo $report_row['acct_name']; ?></a></td>
                        <td align=right><?php echo round($report_row['o_bal'], 0); ?></td>
                      </tr>
                    <?php
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      <?php } ?>
      <!-------------------------------END SUPPLIER SUMMARY--------------------->

    </div>



    <!-------------------------------START ACTIVITY--------------------->


    <div class="row">
      <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12">
        <div class="card">
          <div class="card-header">
            <h4>Recent Activities</h4>
            <div class="card-header-form">
            
            </div>
          </div>
          <div class="card-body">
            <div class="table-responsive proTeamScroll" id="proTeamScroll">
            <table id="activity"  class="table table-borderless " >
                                <thead class="text-center"  >
                                <tr>
                                    <th>Date</th>
                                    <th>Customer</th>
                                    <th>ID</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody class="text-black text-center"  style="font-family: Roboto, sans-serif; color: #101928">
                                <?php

                                try {
                                    $item_query = "SELECT m.comp_id, m.year_id, m.voucher_id, m.voucher_date,   
(ifnull(m.net_amt,0)) net_amt, m.comp_id,  
 v.acct_name customer_name, d.stock_code, m.acct_id
FROM sl_invoice m
LEFT JOIN sl_invoicedet d ON m.comp_id = d.comp_id and m.year_id = d.year_id and m.voucher_id = d.voucher_id

LEFT JOIN v_party v ON m.acct_id = v.acct_id
WHERE m.comp_id = '$comp_id'  and m.voucher_date = '$sysdate' 
 GROUP BY m.voucher_id  ORDER BY m.voucher_date desc";
                                    $item_result = $dbcon->prepare($item_query);
                                    $dbcon->exec("SET NAMES 'utf8';");
                                    $item_result->execute(array());
                                } catch (PDOException $e) {
                                    echo "Error : " . $e->getMessage();
                                }



                                $sr = 0;
                                while ($rows = $item_result->fetch(PDO::FETCH_OBJ)) {
                                $sr += 1;

                                  
                                 

                                    ?>
                                <tr>
                                    <td><?php echo ($rows->voucher_date );?></td>
                                    <td style="font-weight: bold;"><a href="<?php echo $url;?>"><?php echo ($rows->customer_name);?></a></td>

                                    <td style="font-weight: bold;"><a href="sl_inv_detail?v_id=<?php echo $rows->voucher_id;?>"><?php echo ($rows->voucher_id);?></a></td>


                                    <!--


<td><a href="item_profile?stock_code=<?php /*echo $rows->stock_code;*/?>"><?php /*echo ($rows->items);*/?></a></td>
-->                                    <td><?php echo format_number($rows->net_amt, $amt_decimals);?></td>

                                    <td>

                                        <a href="<?php echo $link;?>"><span class=" btn <?php echo $btn_class;?> " style="width: 150px;"><?php echo $status ;?></span></a>

                                    </td>

                                </tr>
                                <?php }?>


                                </tbody>
                            </table>
            </div>
          </div>
        </div>
      </div>

    </div>


    <!-------------------------------END ACTIVITY--------------------->



  </section>
  <div class="settingSidebar">
    <a href="javascript:void(0)" class="settingPanelToggle"> <i class="fa fa-spin fa-cog"></i>
    </a>
    <div class="settingSidebar-body ps-container ps-theme-default">
      <div class=" fade show active">
        <div class="setting-panel-header">Setting Panel
        </div>
        <div class="p-15 border-bottom">
          <h6 class="font-medium m-b-10">Select Layout</h6>
          <div class="selectgroup layout-color w-50">
            <label class="selectgroup-item">
              <input type="radio" name="value" value="1" class="selectgroup-input-radio select-layout" checked>
              <span class="selectgroup-button">Light</span>
            </label>
            <label class="selectgroup-item">
              <input type="radio" name="value" value="2" class="selectgroup-input-radio select-layout">
              <span class="selectgroup-button">Dark</span>
            </label>
          </div>
        </div>
        <div class="p-15 border-bottom">
          <h6 class="font-medium m-b-10">Sidebar Color</h6>
          <div class="selectgroup selectgroup-pills sidebar-color">
            <label class="selectgroup-item">
              <input type="radio" name="icon-input" value="1" class="selectgroup-input select-sidebar">
              <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip" data-original-title="Light Sidebar"><i class="fas fa-sun"></i></span>
            </label>
            <label class="selectgroup-item">
              <input type="radio" name="icon-input" value="2" class="selectgroup-input select-sidebar" checked>
              <span class="selectgroup-button selectgroup-button-icon" data-toggle="tooltip" data-original-title="Dark Sidebar"><i class="fas fa-moon"></i></span>
            </label>
          </div>
        </div>
        <div class="p-15 border-bottom">
          <h6 class="font-medium m-b-10">Color Theme</h6>
          <div class="theme-setting-options">
            <ul class="choose-theme list-unstyled mb-0">
              <li title="white" class="active">
                <div class="white"></div>
              </li>
              <li title="cyan">
                <div class="cyan"></div>
              </li>
              <li title="black">
                <div class="black"></div>
              </li>
              <li title="purple">
                <div class="purple"></div>
              </li>
              <li title="orange">
                <div class="orange"></div>
              </li>
              <li title="green">
                <div class="green"></div>
              </li>
              <li title="red">
                <div class="red"></div>
              </li>
            </ul>
          </div>
        </div>
        <div class="p-15 border-bottom">
          <div class="theme-setting-options">
            <label class="m-b-0">
              <input type="checkbox" name="custom-switch-checkbox" class="custom-switch-input" id="mini_sidebar_setting">
              <span class="custom-switch-indicator"></span>
              <span class="control-label p-l-10">Mini Sidebar</span>
            </label>
          </div>
        </div>
        <div class="p-15 border-bottom">
          <div class="theme-setting-options">
            <label class="m-b-0">
              <input type="checkbox" name="custom-switch-checkbox" class="custom-switch-input" id="sticky_header_setting">
              <span class="custom-switch-indicator"></span>
              <span class="control-label p-l-10">Sticky Header</span>
            </label>
          </div>
        </div>
        <div class="mt-4 mb-4 p-3 align-center rt-sidebar-last-ele">
          <a href="#" class="btn btn-icon icon-left btn-primary btn-restore-theme">
            <i class="fas fa-undo"></i> Restore Default
          </a>
        </div>
      </div>
    </div>
  </div>
</div>


<?php include('footer.php'); ?>


<script>
  $('.customer_table').DataTable({
    "bLengthChange": false,
    "order": [1, "desc"],
    "bPaginate": false,
    "bInfo": false
  });


  $('#activity').DataTable({
    "bLengthChange": false,
    "order": [1, "desc"],
    "bPaginate": false,
    "bInfo": false
  });
</script>